/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;

public class DataPusher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private static final boolean DEBUG = false;
    private SourceDataLine source = null;
    private AudioFormat format = null;
    private AudioInputStream ais = null;
    private byte[] audioData = null;
    private int audioDataByteLength = 0;
    private int pos;
    private int newPos = -1;
    private boolean looping;
    private Thread pushThread = null;
    private int wantedState;
    private int threadState;
    private final int STATE_NONE = 0;
    private final int STATE_PLAYING = 1;
    private final int STATE_WAITING = 2;
    private final int STATE_STOPPING = 3;
    private final int STATE_STOPPED = 4;
    private final int BUFFER_SIZE = 16384;

    synchronized void close() {
        if (this.source != null) {
            this.source.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = null;
        boolean bl2 = this.ais != null;
        byArray = bl2 ? new byte[16384] : this.audioData;
        while (this.wantedState != 3) {
            if (this.wantedState == 2) {
                try {
                    DataPusher dataPusher = this;
                    synchronized (dataPusher) {
                        this.threadState = 2;
                        this.wantedState = 3;
                        this.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (this.newPos >= 0) {
                this.pos = this.newPos;
                this.newPos = -1;
            }
            this.threadState = 1;
            int n2 = 16384;
            if (bl2) {
                try {
                    this.pos = 0;
                    n2 = this.ais.read(byArray);
                }
                catch (IOException iOException) {
                    n2 = -1;
                }
            } else {
                if (n2 > this.audioDataByteLength - this.pos) {
                    n2 = this.audioDataByteLength - this.pos;
                }
                if (n2 == 0) {
                    n2 = -1;
                }
            }
            if (n2 < 0) {
                if (!bl2 && this.looping) {
                    this.pos = 0;
                    continue;
                }
                this.wantedState = 2;
                this.source.drain();
                continue;
            }
            int n3 = this.source.write(byArray, this.pos, n2);
            this.pos += n3;
        }
        this.threadState = 3;
        this.source.flush();
        this.source.stop();
        this.source.flush();
        this.source.close();
        this.threadState = 4;
        DataPusher dataPusher = this;
        synchronized (dataPusher) {
            this.pushThread = null;
            this.notifyAll();
        }
    }

    public synchronized void start() {
        this.start(false);
    }

    public synchronized void stop() {
        if (this.threadState == 3 || this.threadState == 4 || this.pushThread == null) {
            return;
        }
        this.wantedState = 2;
        if (this.source != null) {
            this.source.flush();
        }
        this.notifyAll();
        int n2 = 50;
        while (n2-- >= 0 && this.threadState == 1) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void start(boolean bl2) {
        try {
            if (this.threadState == 3) {
                this.stop();
            }
            this.looping = bl2;
            this.newPos = 0;
            this.wantedState = 1;
            if (!this.source.isOpen()) {
                this.source.open(this.format);
            }
            this.source.flush();
            this.source.start();
            if (this.pushThread == null) {
                this.pushThread = new Thread(this);
                this.pushThread.start();
            }
            this.notifyAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DataPusher(SourceDataLine sourceDataLine, AudioFormat audioFormat, byte[] byArray, int n2) {
        this.audioData = byArray;
        this.audioDataByteLength = n2;
        this.format = audioFormat;
        this.source = sourceDataLine;
    }

    public DataPusher(SourceDataLine sourceDataLine, AudioInputStream audioInputStream) {
        this.ais = audioInputStream;
        this.format = audioInputStream.getFormat();
        this.source = sourceDataLine;
    }
}

